# General RCE Endpoint Example - Recognized Coordinating Entity (RCE) Implementation Guide v1.10.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **General RCE Endpoint Example**

## Example Endpoint: General RCE Endpoint Example

Profile: [RCE Endpoint](StructureDefinition-RCE-Endpoint.md)

**Transaction**: FHIR REST

**Version**: 4.0.1

> **FHIR IG Conformance**
* igCanonicalUrl: [US Core Implementation Guide](http://hl7.org/fhir/us/core/STU4/ImplementationGuide-hl7.fhir.us.core.html)
* igPackage: [https://hl7.org/fhir/us/core/STU6.1/package.tgz](https://hl7.org/fhir/us/core/STU6.1/package.tgz)
* igVersion: 6.1.0
* capStmt: [http://hl7.org/fhir/us/core/CapabilityStatement/us-core-server](http://hl7.org/fhir/us/core/STU4/CapabilityStatement-us-core-server.html)

**Roles**: Medical doctor

**Downtime**: Once per 1 week

**identifier**: Home Community ID/urn:oid:5.5.5.5 (use: official, )

**status**: Active

**connectionType**: [Endpoint Connection Type: ihe-xcpd](http://terminology.hl7.org/7.0.1/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-ihe-xcpd) (IHE XCPD)

**name**: Example RCE Endpoint

**managingOrganization**: [Organization RCE QHIN Example](Organization-QHIN-example.md)

**payloadType**: NoInformation

**payloadMimeType**: application/xml

**address**: [https://example.org/xcpd/v1/xcpd](https://example.org/xcpd/v1/xcpd)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "RCE-orgEndpoint",
  "meta" : {
    "profile" : [
      "https://sequoiaproject.org/fhir/rce/StructureDefinition/RCE-Endpoint"
    ]
  },
  "extension" : [
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/Transaction",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/TransactionCodes",
            "code" : "FHIR REST"
          }
        ]
      }
    },
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/Version",
      "valueString" : "4.0.1"
    },
    {
      "extension" : [
        {
          "url" : "igCanonicalUrl",
          "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
        },
        {
          "url" : "igPackage",
          "valueUrl" : "https://hl7.org/fhir/us/core/STU6.1/package.tgz"
        },
        {
          "url" : "igVersion",
          "valueString" : "6.1.0"
        },
        {
          "url" : "capStmt",
          "valueUrl" : "http://hl7.org/fhir/us/core/CapabilityStatement/us-core-server"
        }
      ],
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/FHIRIGConformance"
    },
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/Roles",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "112247003",
            "display" : "Medical doctor"
          }
        ]
      }
    },
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/Downtime",
      "valueTiming" : {
        "repeat" : {
          "period" : 1,
          "periodUnit" : "wk"
        }
      }
    }
  ],
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/SequoiaIdentifierCodes",
            "code" : "HCID"
          }
        ]
      },
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:5.5.5.5"
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
    "code" : "ihe-xcpd"
  },
  "name" : "Example RCE Endpoint",
  "managingOrganization" : {
    "reference" : "Organization/QHIN-example"
  },
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
          "code" : "NI"
        }
      ]
    }
  ],
  "payloadMimeType" : ["application/xml"],
  "address" : "https://example.org/xcpd/v1/xcpd"
}

```
