# Update TEFCAID for Entry and Children - Recognized Coordinating Entity (RCE) Implementation Guide v1.10.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Update TEFCAID for Entry and Children**

## OperationDefinition: Update TEFCAID for Entry and Children 

| | |
| :--- | :--- |
| *Official URL*:https://sequoiaproject.org/fhir/rce/OperationDefinition/update-tefcaid | *Version*:1.10.0 |
| Active as of 2026-01-20 | *Computable Name*:Update TEFCAID for Entry and Children |

 
Updates the TEFCAID identifier for the specified Organization and all Child Organizations that descend from it (directly or indirectly through other Children) via Organization.partOf. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "update-tefcaid",
  "url" : "https://sequoiaproject.org/fhir/rce/OperationDefinition/update-tefcaid",
  "version" : "1.10.0",
  "name" : "Update TEFCAID for Entry and Children",
  "title" : "Update TEFCAID for Entry and Children",
  "status" : "active",
  "kind" : "operation",
  "date" : "2026-01-20T11:10:43-05:00",
  "publisher" : "Recognized Coordinating Entity (RCE)",
  "contact" : [
    {
      "name" : "Recognized Coordinating Entity (RCE)",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://rce.sequoiaproject.org/rce/"
        }
      ]
    }
  ],
  "description" : "Updates the TEFCAID identifier for the specified Organization and all Child Organizations that descend from it (directly or indirectly through other Children) via Organization.partOf.",
  "code" : "update-tefcaid",
  "base" : "https://sequoiaproject.org/fhir/rce/OperationDefinition/update-tefcaid",
  "resource" : ["Organization"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "parameter" : [
    {
      "name" : "tefcaid",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The TEFCAID, expressed either as system|value (urn:ietf:rfc:3986|[uuid]) or as a value only ([uuid]).",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "documentation" : "A List of Organizations changed by this operation.",
      "type" : "List"
    }
  ]
}

```
