# Downloads - Recognized Coordinating Entity (RCE) Implementation Guide v1.10.0

* [**Table of Contents**](toc.md)
* **Downloads**

## Downloads

### Full Implementation Guide

The entire implementation guide (including the HTML files, definitions, validation information, etc.) may be downloaded [here](full-ig.zip).

In addition there are format specific definitions files.

* [XML](definitions.xml.zip)
* [JSON](definitions.json.zip)
* [TTL](definitions.ttl.zip)

### Examples

All the examples that are used in this Implementation Guide available for download:

* [XML](examples.xml.zip)
* [JSON](examples.json.zip)
* [TTl](examples.ttl.zip)

### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (sequoia.fhir.us.rce.r4)](package.r4.tgz) and [R4B (sequoia.fhir.us.rce.r4b)](package.r4b.tgz) are available.

### Dependency Table







### Globals Table

*There are no Global profiles defined*

### IP Statements

This publication includes IP covered under the following statements.

* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [Example RCE Endpoint](Endpoint-RCE-orgEndpoint.md) and [RCE Participant Example](Organization-1.2.3.4.5.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Contact entity type](http://terminology.hl7.org/7.0.1/CodeSystem-contactentity-type.html): [Participant 1](Organization-Q.A.P.1.md), [Participant 2](Organization-Q.A.P.2.md)...Show 13 more,[Participant 3](Organization-Q.B.P.3.md),[QHIN A](Organization-Q.A.0.0.md),[QHIN B](Organization-Q.B.0.0.md),[RCE Child Example](Organization-RCE-Child-example.md),[RCE Participant Example](Organization-1.2.3.4.5.md),[RCE QHIN Example](Organization-QHIN-example.md),[RCE Subparticipant Example](Organization-5.4.3.2.1.md),[Sub U](Organization-Q.B.P.3.1.1.md),[Sub V](Organization-Q.B.P.3.2.md),[Sub W](Organization-Q.B.P.3.1.md),[Sub X](Organization-Q.A.P.2.1.md),[Sub Y](Organization-Q.A.P.1.2.md)and[Sub Z](Organization-Q.A.P.1.1.md)
* [Endpoint Connection Type](http://terminology.hl7.org/7.0.1/CodeSystem-endpoint-connection-type.html): [Example RCE Endpoint](Endpoint-RCE-orgEndpoint.md), [Participant 1](Organization-Q.A.P.1.md)...Show 11 more,[Participant 2](Organization-Q.A.P.2.md),[Participant 3](Organization-Q.B.P.3.md),[QHIN A](Organization-Q.A.0.0.md),[QHIN B](Organization-Q.B.0.0.md),[RCE Participant Example](Organization-1.2.3.4.5.md),[RCE Subparticipant Example](Organization-5.4.3.2.1.md),[Sub U](Organization-Q.B.P.3.1.1.md),[Sub V](Organization-Q.B.P.3.2.md),[Sub W](Organization-Q.B.P.3.1.md),[Sub Y](Organization-Q.A.P.1.2.md)and[Sub Z](Organization-Q.A.P.1.1.md)
* [NullFlavor](http://terminology.hl7.org/7.0.1/CodeSystem-v3-NullFlavor.html): [Example RCE Endpoint](Endpoint-RCE-orgEndpoint.md), [Participant 1](Organization-Q.A.P.1.md)...Show 11 more,[Participant 2](Organization-Q.A.P.2.md),[Participant 3](Organization-Q.B.P.3.md),[QHIN A](Organization-Q.A.0.0.md),[QHIN B](Organization-Q.B.0.0.md),[RCE Participant Example](Organization-1.2.3.4.5.md),[RCE Subparticipant Example](Organization-5.4.3.2.1.md),[Sub U](Organization-Q.B.P.3.1.1.md),[Sub V](Organization-Q.B.P.3.2.md),[Sub W](Organization-Q.B.P.3.1.md),[Sub Y](Organization-Q.A.P.1.2.md)and[Sub Z](Organization-Q.A.P.1.1.md)


