# Introduction - Recognized Coordinating Entity (RCE) Implementation Guide v1.10.0

* [**Table of Contents**](toc.md)
* **Introduction**

## Introduction

| | |
| :--- | :--- |
| *Official URL*:https://sequoiaproject.org/fhir/rce/ImplementationGuide/sequoia.fhir.us.rce | *Version*:1.10.0 |
| Active as of 2026-01-20 | *Computable Name*:RCEIG |

### Overview

As defined in the Common Agreement, and additional requirements in the QHIN Technical Framework (QTF), this RCE Directory Service Implementation Guide is used by Qualified Health Information Networks (QHINs) to share identifying information of QHINs, Participants, and Subparticipants, including relevant Child entities. The RCE Directory Service is only accessible to QHINs, and is shared by QHINs to their own Participants and Subparticipants according to the requirements set forth in Section 8 of the Common Agreement available at [https://rce.sequoiaproject.org/tefca-and-rce-resources/](https://rce.sequoiaproject.org/tefca-and-rce-resources/).

Technical details for this RCE Implementation Guide, including Actors, Profiles, Extensions, etc. can be found on the following page

* [RCE Specification](rce_specification.md)

This RCE Directory Service Implementation Guide (IG) is based on the following specifications:

* [US Core 4.0.0](http://hl7.org/fhir/us/core/STU4/) which defines the [US Core Organization](http://hl7.org/fhir/us/core/STU4/StructureDefinition-us-core-organization.html) profile
* [Sequoia Project Healthcare Directory Implementation Guide](https://sequoiaproject.org/SequoiaProjectHealthcareDirectoryImplementationGuide/output/index.html), which defines artifacts such as Profiles, Extensions, Value Sets, and Code Systems that are shared by all Sequoia project FHIR directories.

For RCE implementers that are new to HL7 FHIR, the spec itself has introductory material available such as:

* [FHIR Overview](http://hl7.org/fhir/R4/overview.html)
* [Executive summary](http://hl7.org/fhir/R4/summary.html)
* [Developer introduction](http://hl7.org/fhir/R4/overview-dev.html)
* [Architect introduction](http://hl7.org/fhir/R4/overview-arch.html)

### Authors

| | |
| :--- | :--- |
| Recognized Coordinating Entity (RCE) | [http://rce.sequoiaproject.org/rce/](http://rce.sequoiaproject.org/rce/) |



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "sequoia.fhir.us.rce",
  "url" : "https://sequoiaproject.org/fhir/rce/ImplementationGuide/sequoia.fhir.us.rce",
  "version" : "1.10.0",
  "name" : "RCEIG",
  "title" : "Recognized Coordinating Entity (RCE) Implementation Guide",
  "status" : "active",
  "date" : "2026-01-20T11:10:43-05:00",
  "publisher" : "Recognized Coordinating Entity (RCE)",
  "contact" : [
    {
      "name" : "Recognized Coordinating Entity (RCE)",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://rce.sequoiaproject.org/rce/"
        }
      ]
    }
  ],
  "packageId" : "sequoia.fhir.us.rce",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "sphd",
      "uri" : "https://sequoiaproject.org/fhir/sphd/ImplementationGuide/sequoia.fhir.us.sphd",
      "packageId" : "sequoia.fhir.us.sphd",
      "version" : "dev"
    },
    {
      "id" : "udap",
      "uri" : "http://hl7.org/fhir/us/udap-security/ImplementationGuide/hl7.fhir.us.udap-security",
      "packageId" : "hl7.fhir.us.udap-security",
      "version" : "1.1.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "Release 1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://sequoiaproject.org/fhir/rce/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.9.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "Release 1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://sequoiaproject.org/fhir/rce/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/activate-hierarchy"
        },
        "name" : "Activate Hierarchy",
        "description" : "This operation changes the Organization.active element to true for the specified Organization and all Organizations that descend from it (directly or indirectly) via Organization.partOf.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Child"
        },
        "name" : "Child",
        "description" : "The Child profile represents the individual components (such as member organizations, facilities, locations, etc.) that make up a QHIN, Participant, or Subparticipant. A Child can be the parent of other Child organizations. A Child can not be an endpoint (node). It can be part of an endpoint (node) but does not meet the definition of an endpoint (node) itself. The maximum cardinality for an endpoint (node) element under a child is 0.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/deactivate-hierarchy"
        },
        "name" : "Deactivate Hierarchy",
        "description" : "This operation changes the Organization.active element to false for the specified Organization and all Organizations that descend from it (directly or indirectly) via Organization.partOf.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/RCE-Child-example"
        },
        "name" : "General RCE Child Example",
        "description" : "Example RCE Child Organization instance.  This example shows a 3rd-level organization below the RCE Subparticipant example.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/Child"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Endpoint"
          }
        ],
        "reference" : {
          "reference" : "Endpoint/RCE-orgEndpoint"
        },
        "name" : "General RCE Endpoint Example",
        "description" : "Example RCE Endpoint instance. Note that the RCE Directory currently expects Endpoint instances to be contained resources within an Organization resource.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/RCE-Endpoint"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/1.2.3.4.5"
        },
        "name" : "General RCE Participant Example",
        "description" : "Example RCE Participant Organization instance. This example shows a top level organization participating in a QHIN, which is the direct parent of the RCE Subparticipant example. In includes a contained FHIR Endpoint.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/Participant"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/QHIN-example"
        },
        "name" : "General RCE QHIN Example",
        "description" : "Example RCE QHIN Organization instance. This example shows a TEFCA Qualified Health Information Network (QHIN) organization in the RCE directory. It is the top-level parent of the other examples in this IG, and the direct parent of the RCE Participant example.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/QHIN"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/5.4.3.2.1"
        },
        "name" : "General RCE Subparticipant Example",
        "description" : "Example RCE Participant Organization instance. This example shows a 2nd level organization below an RCE Participant organization. This example is the direct parent of the RCE Child example. It includes a contained XCDR Endpoint.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/SubParticipant"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Participant"
        },
        "name" : "Participant",
        "description" : "The Participant profile represents a Participant as defined in the Common Agreement. A Participant can be the parent of Subparticipant and Child organizations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Q.A.P.1"
        },
        "name" : "Participant 1",
        "description" : "This example shows Participant 1, a top level organization participating in a QHIN A. Participant 1 maintains an eMPI/Record Locator Service (RLS) over its Subparticipants, Sub Y and Sub Z, but returns individual patient IDs per Subparticipant and passes down subsequent Queries for documents.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/Participant"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Q.A.P.2"
        },
        "name" : "Participant 2",
        "description" : "This example shows Participant 2, a top level organization participating in a QHIN A. Participant 2 maintains a complete clinical data repository and Responds for all transactions for its Subparticipant, Sub X.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/Participant"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Q.B.P.3"
        },
        "name" : "Participant 3",
        "description" : "This example shows Participant 3, a top level organization participating in a QHIN B. Participant 3 is a fully federated Passthrough Node, passing all transactions to its Subparticipants, Sub U, Sub V, and Sub W.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/Participant"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/QHIN"
        },
        "name" : "QHIN",
        "description" : "The QHIN profile represents a Qualified Health Information Network as defined in the Common Agreement. A QHIN can be the parent of Participant, Subparticipant, and Child organizations.\nThere will be exactly one QHIN Organization resource per Designated QHIN.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Q.A.0.0"
        },
        "name" : "QHIN A",
        "description" : "This example shows QHIN A, which is fully federated (no centralized data or patient index) and passes all transactions to its participants, Participant 1 and Participant 2.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/QHIN"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Q.B.0.0"
        },
        "name" : "QHIN B",
        "description" : "This example shows QHIN B, which maintains an eMPI/RLS and returns a consolidated patient ID, followed by an aggregated document list. It passes down subsequent Queries for documents to its participant, Participant 3.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/QHIN"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/RCE-Endpoint"
        },
        "name" : "RCE Endpoint",
        "description" : "This profile on the FHIR Endpoint resource represents information about the endpoints provided by Organizations participating in TEFCA exchange. The endpoints described can use any QTF-supported protocol, such as IHE XCA, and need not be FHIR endpoints.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/RCE-Organization"
        },
        "name" : "RCE Organization",
        "description" : "This profile on the FHIR Organization resource is an abstract base profile that defines shared constraints for all other profiles on the Organization resource in this implementation guide. It is not intended to be used directly, rather end users should create instances conforming to the QHIN, Participant, Subparticipant, or Child profiles.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Q.B.P.3.1.1"
        },
        "name" : "Sub U",
        "description" : "This example shows Sub U, a Subparticipant (3rd level organization) of Sub W. It only sees Document Retrieval Queries and Responds independently (XCA Responds), since Sub W and Participant 3 are fully federated Passthrough Nodes and QHIN B maintains its patient demographics and document list.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/SubParticipant"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Q.B.P.3.2"
        },
        "name" : "Sub V",
        "description" : "This example shows Sub V, a Subparticipant (2nd level organization) of Participant 3. It only sees Document Retrieval Queries and Responds independently (XCA Responds), since Participant 3 is a fully federated Passthrough Node and QHIN B maintains its patient demographics and document list.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/SubParticipant"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Q.B.P.3.1"
        },
        "name" : "Sub W",
        "description" : "This example shows Sub W, a Subparticipant (2nd level organization) of Participant 3. It is a fully federated Passthrough Node, passing all transactions to its Subparticipant, Sub U.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/SubParticipant"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Q.A.P.2.1"
        },
        "name" : "Sub X",
        "description" : "This example shows a Child (a 2nd-level organization with no Endpoint) of Participant 2, called 'Sub X'. It never sees or Responds directly to TEFCA transactions, since Participant 2 maintains a complete clinical data repository and Responds for all transactions for all of its Child sorganization.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/Child"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Q.A.P.1.2"
        },
        "name" : "Sub Y",
        "description" : "This example shows Sub Y, a Subparticipant (2nd level organization) of Participant 1. It sees only Document Query and Document Retrieval Queries from Participant 1, and it Respond independently (XCA Queries and Responds), since Participant 1 only maintains its patient demographics.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/SubParticipant"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Q.A.P.1.1"
        },
        "name" : "Sub Z",
        "description" : "This example shows Sub Z, a Subparticipant (2nd level organization) of Participant 1. It sees only Document Query and Document Retrieval Queries from Participant 1, and it Respond independently (XCA Queries and Responds), since Participant 1 only maintains its patient demographics.",
        "exampleCanonical" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/SubParticipant"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SubParticipant"
        },
        "name" : "Subparticipant",
        "description" : "The Subparticipant profile represents a Subparticipant as defined in the Common Agreement. A Subparticipant can be the parent of Subparticipant and Child organizations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/update-tefcaid"
        },
        "name" : "Update TEFCAID for Entry and Children",
        "description" : "This operation updates the TEFCAID identifier for the specified Organization and all Child Organizations that descend from it (directly or indirectly through other Children) via Organization.partOf.",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Introduction",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "rce_specification.html"
            }
          ],
          "nameUrl" : "rce_specification.html",
          "title" : "Specification",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "change_log.html"
            }
          ],
          "nameUrl" : "change_log.html",
          "title" : "Change Log",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
