# Participant - Recognized Coordinating Entity (RCE) Implementation Guide v1.10.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Participant**

## Resource Profile: Participant 

| | |
| :--- | :--- |
| *Official URL*:https://sequoiaproject.org/fhir/rce/StructureDefinition/Participant | *Version*:1.10.0 |
| Active as of 2026-01-20 | *Computable Name*:Participant |

 
The Participant profile represents a Participant as defined in the Common Agreement. A Participant can be the parent of Subparticipant and Child organizations. 

**Usages:**

* Refer to this Profile: [Child](StructureDefinition-Child.md) and [Subparticipant](StructureDefinition-SubParticipant.md)
* Examples for this Profile: [RCE Participant Example](Organization-1.2.3.4.5.md), [Participant 1](Organization-Q.A.P.1.md), [Participant 2](Organization-Q.A.P.2.md) and [Participant 3](Organization-Q.B.P.3.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/sequoia.fhir.us.rce|current/StructureDefinition/Participant)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Participant.csv), [Excel](StructureDefinition-Participant.xlsx), [Schematron](StructureDefinition-Participant.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Participant",
  "url" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/Participant",
  "version" : "1.10.0",
  "name" : "Participant",
  "title" : "Participant",
  "status" : "active",
  "date" : "2026-01-20T11:10:43-05:00",
  "publisher" : "Recognized Coordinating Entity (RCE)",
  "contact" : [
    {
      "name" : "Recognized Coordinating Entity (RCE)",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://rce.sequoiaproject.org/rce/"
        }
      ]
    }
  ],
  "description" : "The Participant profile represents a Participant as defined in the Common Agreement. A Participant can be the parent of Subparticipant and Child organizations.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/RCE-Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.extension",
        "path" : "Organization.extension",
        "min" : 2
      },
      {
        "id" : "Organization.extension:org-managing-org",
        "path" : "Organization.extension",
        "sliceName" : "org-managing-org",
        "min" : 1
      },
      {
        "id" : "Organization.type:sequoiaorgtype",
        "path" : "Organization.type",
        "sliceName" : "sequoiaorgtype",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/OrganizationType",
              "code" : "Participant"
            }
          ]
        }
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "min" : 1,
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://sequoiaproject.org/fhir/rce/StructureDefinition/QHIN"
            ]
          }
        ]
      }
    ]
  }
}

```
