# QHIN - Recognized Coordinating Entity (RCE) Implementation Guide v1.10.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QHIN**

## Resource Profile: QHIN 

| | |
| :--- | :--- |
| *Official URL*:https://sequoiaproject.org/fhir/rce/StructureDefinition/QHIN | *Version*:1.10.0 |
| Active as of 2026-01-20 | *Computable Name*:QHIN |

 
The QHIN profile represents a Qualified Health Information Network as defined in the Common Agreement. A QHIN can be the parent of Participant, Subparticipant, and Child organizations. There will be exactly one QHIN Organization resource per Designated QHIN. 

**Usages:**

* Refer to this Profile: [Child](StructureDefinition-Child.md), [Participant](StructureDefinition-Participant.md) and [Subparticipant](StructureDefinition-SubParticipant.md)
* Examples for this Profile: [QHIN A](Organization-Q.A.0.0.md), [QHIN B](Organization-Q.B.0.0.md) and [RCE QHIN Example](Organization-QHIN-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/sequoia.fhir.us.rce|current/StructureDefinition/QHIN)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-QHIN.csv), [Excel](StructureDefinition-QHIN.xlsx), [Schematron](StructureDefinition-QHIN.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "QHIN",
  "url" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/QHIN",
  "version" : "1.10.0",
  "name" : "QHIN",
  "title" : "QHIN",
  "status" : "active",
  "date" : "2026-01-20T11:10:43-05:00",
  "publisher" : "Recognized Coordinating Entity (RCE)",
  "contact" : [
    {
      "name" : "Recognized Coordinating Entity (RCE)",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://rce.sequoiaproject.org/rce/"
        }
      ]
    }
  ],
  "description" : "The QHIN profile represents a Qualified Health Information Network as defined in the Common Agreement. A QHIN can be the parent of Participant, Subparticipant, and Child organizations.\nThere will be exactly one QHIN Organization resource per Designated QHIN.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/RCE-Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.type:sequoiaorgtype",
        "path" : "Organization.type",
        "sliceName" : "sequoiaorgtype",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/OrganizationType",
              "code" : "QHIN"
            }
          ]
        }
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "max" : "0"
      },
      {
        "id" : "Organization.contact",
        "path" : "Organization.contact",
        "min" : 1
      }
    ]
  }
}

```
