# RCE Endpoint - Recognized Coordinating Entity (RCE) Implementation Guide v1.10.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RCE Endpoint**

## Resource Profile: RCE Endpoint 

| | |
| :--- | :--- |
| *Official URL*:https://sequoiaproject.org/fhir/rce/StructureDefinition/RCE-Endpoint | *Version*:1.10.0 |
| Active as of 2026-01-20 | *Computable Name*:RCEEndpoint |

 
This profile on the FHIR Endpoint resource represents information about the endpoints provided by Organizations participating in TEFCA exchange. The endpoints described can use any QTF-supported protocol, such as IHE XCA, and need not be FHIR endpoints. 

**Usages:**

* Refer to this Profile: [RCE Organization](StructureDefinition-RCE-Organization.md)
* Examples for this Profile: [Example RCE Endpoint](Endpoint-RCE-orgEndpoint.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/sequoia.fhir.us.rce|current/StructureDefinition/RCE-Endpoint)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-RCE-Endpoint.csv), [Excel](StructureDefinition-RCE-Endpoint.xlsx), [Schematron](StructureDefinition-RCE-Endpoint.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "RCE-Endpoint",
  "url" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/RCE-Endpoint",
  "version" : "1.10.0",
  "name" : "RCEEndpoint",
  "title" : "RCE Endpoint",
  "status" : "active",
  "date" : "2026-01-20T11:10:43-05:00",
  "publisher" : "Recognized Coordinating Entity (RCE)",
  "contact" : [
    {
      "name" : "Recognized Coordinating Entity (RCE)",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://rce.sequoiaproject.org/rce/"
        }
      ]
    }
  ],
  "description" : "This profile on the FHIR Endpoint resource represents information about the endpoints provided by Organizations participating in TEFCA exchange. The endpoints described can use any QTF-supported protocol, such as IHE XCA, and need not be FHIR endpoints.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Endpoint",
  "baseDefinition" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/SequoiaEndpoint",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Endpoint",
        "path" : "Endpoint"
      },
      {
        "id" : "Endpoint.extension:purposesofuse",
        "path" : "Endpoint.extension",
        "sliceName" : "purposesofuse"
      },
      {
        "id" : "Endpoint.extension:purposesofuse.value[x]",
        "path" : "Endpoint.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://sequoiaproject.org/fhir/sphd/ValueSet/RCEPurposeVS"
        }
      },
      {
        "id" : "Endpoint.managingOrganization",
        "path" : "Endpoint.managingOrganization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://sequoiaproject.org/fhir/rce/StructureDefinition/RCE-Organization"
            ]
          }
        ]
      }
    ]
  }
}

```
