# Introduction - Recognized Coordinating Entity (RCE) Implementation Guide v1.10.0

* [**Table of Contents**](toc.md)
* **Introduction**

## Introduction

| | |
| :--- | :--- |
| *Official URL*:https://sequoiaproject.org/fhir/rce/ImplementationGuide/sequoia.fhir.us.rce | *Version*:1.10.0 |
| Active as of 2026-01-20 | *Computable Name*:RCEIG |

### Overview

As defined in the Common Agreement, and additional requirements in the QHIN Technical Framework (QTF), this RCE Directory Service Implementation Guide is used by Qualified Health Information Networks (QHINs) to share identifying information of QHINs, Participants, and Subparticipants, including relevant Child entities. The RCE Directory Service is only accessible to QHINs, and is shared by QHINs to their own Participants and Subparticipants according to the requirements set forth in Section 8 of the Common Agreement available at [https://rce.sequoiaproject.org/tefca-and-rce-resources/](https://rce.sequoiaproject.org/tefca-and-rce-resources/).

Technical details for this RCE Implementation Guide, including Actors, Profiles, Extensions, etc. can be found on the following page

* [RCE Specification](rce_specification.md)

This RCE Directory Service Implementation Guide (IG) is based on the following specifications:

* [US Core 4.0.0](http://hl7.org/fhir/us/core/STU4/) which defines the [US Core Organization](http://hl7.org/fhir/us/core/STU4/StructureDefinition-us-core-organization.html) profile
* [Sequoia Project Healthcare Directory Implementation Guide](https://sequoiaproject.org/SequoiaProjectHealthcareDirectoryImplementationGuide/output/index.html), which defines artifacts such as Profiles, Extensions, Value Sets, and Code Systems that are shared by all Sequoia project FHIR directories.

For RCE implementers that are new to HL7 FHIR, the spec itself has introductory material available such as:

* [FHIR Overview](http://hl7.org/fhir/R4/overview.html)
* [Executive summary](http://hl7.org/fhir/R4/summary.html)
* [Developer introduction](http://hl7.org/fhir/R4/overview-dev.html)
* [Architect introduction](http://hl7.org/fhir/R4/overview-arch.html)

### Authors

| | |
| :--- | :--- |
| Recognized Coordinating Entity (RCE) | [http://rce.sequoiaproject.org/rce/](http://rce.sequoiaproject.org/rce/) |

