# Specification - Recognized Coordinating Entity (RCE) Implementation Guide v1.10.0

* [**Table of Contents**](toc.md)
* **Specification**

## Specification

### API Key

Access to the RCE Directory requires the presentation of a valid API Key. The API key is a value that is unique to each client and for each environment. The key serves to perform several functions:

It allows the RCE Directory server to immediately, and efficiently, discard invalid queries, such as those from an unauthorized client software package. It allows for audit logging of requests. It allows the server to provide more detailed diagnostics to client applications. It allows The Sequoia Project to identify the organization associated with errant queries, excessive utilization, or other issues. To obtain an API key please send an email to techsupport@sequoiaproject.org. Once your email has been received by the technical support system, you will automatically be assigned a ticket ID (called a conversation ID), and an automatic response will be sent to your organization to acknowledge receipt of your email. If you do not receive an automatic response, then the support system likely did not receive your support request.

One key will be needed for each environment. A key intended for VAL cannot successful be used in PROD, for example.

To present the key upon an API call to the Sequoia directory in a URL, the following syntax must be used:

GET http://BASE-URL/Organization/?_apiKey=1234

Where the value BASE-URL is replaced by the value provided to you when directory access is granted, and the value 1234 is replaced by your API key value. The API key parameter must be exactly as shows, with a preceding underscore and capital K: _apiKey.

The API key can also be passed in an authorization header as follows (spelled "api-key" in this case, all lowercase with a hyphen):

Authorization: api-key 1234

### Actors

#### RCE Requestor

An application that initiates a data access request to retrieve organization data from an RCE responder. The RCE Requestor is a read-only client in a client-server interaction.

#### RCE Submitter

An application that supplies organization data to an RCE Responder. The RCE Submitter is a write-enabled client in a client-server interaction.

#### RCE Responder

A system that responds to data access requests for and submissions of organization data from RCE Requestor and RCE Submitter actors. The RCE responder is the server in a client-server interaction. The terms “RCE Responder”, “RCE Server”, and “RCE Directory” are used interchangeably throughout this guide.

### Profiles and Extensions

This Implementation Guide is based on [US Core Release 4.0.0](http://hl7.org/fhir/us/core/STU4/) and the [Sequoia Project Healthcare Directory Implementation Guide](https://rce.sequoiaproject.org/SequoiaProjectHealthcareDirectoryImplementationGuide/output/index.html). Implementation artifacts such as Profiles, Extensions, and Value Sets defined in those are not copied in this IG, rather are referenced via URLs, so while navigating this guide you may need to follow links to other IGs as well as the FHIR R4 core specification for full details.

#### Profiles

The following profiles are defined in this implementation guide:

* [**RCE Endpoint**](StructureDefinition-RCE-Endpoint.md): All Endpoint resources in in the RCE directory must conform to this profile. Currently RCE Endpoint instances are expected to be contained resources inside Organization resource instances.
* [**RCE Organization (Abstract)**](StructureDefinition-RCE-Organization.md): An abstract base profile used by the other Organization profiles used in this IG. This profile is not intended be instantiated directly, rather, all Organization resource instances in the RCE should conform to one of the following Organization profiles that are derived from it.
* [**QHIN**](StructureDefinition-QHIN.md): The Organization resource profile for Qualified Health Information Networks (QHINs). QHINs are top level organizations and as such are not allowed to be part of other organizations in the directory (Organization.partOf is set to 0..0). A QHIN can be the parent of Participant, Subparticipant, and Child organizations.
* [**Participant**](StructureDefinition-Participant.md): The Participant profile represents a Participant as defined in the Common Agreement. A Participant can be the parent of Subparticipant and Child organizations.
* [**Subparticipant**](StructureDefinition-SubParticipant.md): The Subparticipant profile represents a Subparticipant as defined in the Common Agreement. A Subparticipant can be the parent of Subparticipant and Child organizations.
* [**Child**](StructureDefinition-Child.md): The Child profile represents the individual components (such as member organizations, facilities, locations, etc.) that make up a QHIN, Participant, or Subparticipant. A Child can be the parent of other Child organizations. A Child can not be an endpoint (node). It can be part of an endpoint (node) but does not meet the definition of an endpoint (node) itself.

The following profiles are used in this IG, but defined elsewhere:

* [**Sequoia Location**](https://rce.sequoiaproject.org/SequoiaProjectHealthcareDirectoryImplementationGuide/output/StructureDefinition-SequoiaLocation.html): This profile on the FHIR Location resource is used to store geolocation data about an address, as well as the OrgRole extension. If not set by the QHIN when publishing an Organization address to the Directory, SequoiaLocation is created by the Directory with geolocation Position details determined from the provided physical address.

#### Extensions

This IG does not define any new extensions. However, all RCE Actors must support the following extensions that are defined elsewhere.

* [**Domains**](https://rce.sequoiaproject.org/SequoiaProjectHealthcareDirectoryImplementationGuide/output/StructureDefinition-Domains.html): This extension is used on the Organization resource and indicates which Sequoia directory (or directories) the Organization participantes in. The current legal values are CQ, eHx, and RCE. Most Organizations would only have a single value in this extension.
* [**Initiator Only**](https://rce.sequoiaproject.org/SequoiaProjectHealthcareDirectoryImplementationGuide/output/StructureDefinition-InitiatorOnly.html): When an Organization participates in a Use Case that includes a requirement to respond to requests from others, this extension may be used on that Organization resource to indicate that they meet an Initiator Only exception and do not have Endpoints for that Use Case, if allowed by the Use Case’s Initiator Only policies.
* [**OrgManagingOrg**](https://rce.sequoiaproject.org/SequoiaProjectHealthcareDirectoryImplementationGuide/output/StructureDefinition-org-managing-org.html): This extension is directly tied to the Directory server access API key allowing Organizations to be created, updated, and deleted only by their managing Organization. This is typically the top-level Organization in the hierarchical chain defined by Organization.partOf.
* [**Purposes of Use**](https://rce.sequoiaproject.org/SequoiaProjectHealthcareDirectoryImplementationGuide/output/StructureDefinition-PurposesOfUse.html): This extension is used on both the Endpoint and Organization resources. For an Endpoint, this extension defines the Purpose(s) of Use for which the Endpoint will receive and respond to requests from others. An Organization may have multiple Endpoints for the same Transaction type that receive and process different Purposes of Use. For an Organization, this extension defines the Purpose(s) of Use for which the Organization will initiate requests to others.
* [**State of Operation**](https://rce.sequoiaproject.org/SequoiaProjectHealthcareDirectoryImplementationGuide/output/StructureDefinition-StateOfOperation.html): This extension is used on the Organization resource. It is repeatable, and each instances contains a state or province in which the organization operates.
* [**Use Cases**](https://rce.sequoiaproject.org/SequoiaProjectHealthcareDirectoryImplementationGuide/output/StructureDefinition-UseCases.html): When an implementation of the RCE Directory has unique requirements tied to specific Use Case participation, this extension is used on the Organization resource to indicate which Use Case(s) the Organization participates in.

There are other extensions defined in the Sequoia Project Healthcare Directory IG that may be present in RCE instances, but are not flagged as must-support and thus may be ignored by implementers. Full definitions of all such extensions maybe be found [here](https://rce.sequoiaproject.org/SequoiaProjectHealthcareDirectoryImplementationGuide/output/artifacts.html#structures-extension-definitions).

### General Guidance

#### US Core and the RCE Implementation Guide

All the Organization resource profiles in this guide inherit from the [Sequoia Organization](https://rce.sequoiaproject.org/SequoiaProjectHealthcareDirectoryImplementationGuide/output/StructureDefinition-SequoiaOrganization.html) profile in the Sequoia Project Healthcare Directory IG, which in turn inherits from [US Core Organization](http://hl7.org/fhir/us/core/STU4/StructureDefinition-us-core-organization.html).

#### Must Support

This implementation guide derives from US Core, and as such has the same [must support obligations as US Core](http://hl7.org/fhir/us/core/STU4/conformance-expectations.html#must-support-elements).

#### Contained Resources

Currently the RCE directory only exposes Organization resources for direct queries. Endpoint and Location resources are only available as contained resources within Organization, and cannot be queried for or updated separately. That said, RCE Requestor actors are encouraged not to rely on this always being true in the future, and should instead familiarize themselves with how [FHIR references](http://hl7.org/fhir/references.html) work. For example, if Organization.endpoint begins with a "#" symbol, the reference is contained locally within the Organization, otherwise it is a URI pointing to a resource that exists standalone on RCE Directory server or elsewhere within a Bundle if processing a Bundle resource.

