# Child - Recognized Coordinating Entity (RCE) Implementation Guide v1.11.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Child**

## Resource Profile: Child 

| | |
| :--- | :--- |
| *Official URL*:https://sequoiaproject.org/fhir/rce/StructureDefinition/Child | *Version*:1.11.0 |
| Active as of 2026-02-12 | *Computable Name*:Child |

 
The Child profile represents the individual components (such as member organizations, facilities, locations, etc.) that make up a QHIN, Participant, or Subparticipant. A Child can be the parent of other Child organizations. A Child can not be an endpoint (node). It can be part of an endpoint (node) but does not meet the definition of an endpoint (node) itself. The maximum cardinality for an endpoint (node) element under a child is 0. 

**Usages:**

* Refer to this Profile: [Child](StructureDefinition-Child.md)
* Examples for this Profile: [Sub X](Organization-Q.A.P.2.1.md) and [RCE Child Example](Organization-RCE-Child-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/sequoia.fhir.us.rce|current/StructureDefinition/Child)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Child.csv), [Excel](StructureDefinition-Child.xlsx), [Schematron](StructureDefinition-Child.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Child",
  "url" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/Child",
  "version" : "1.11.0",
  "name" : "Child",
  "title" : "Child",
  "status" : "active",
  "date" : "2026-02-12T10:03:34-05:00",
  "publisher" : "Recognized Coordinating Entity (RCE)",
  "contact" : [
    {
      "name" : "Recognized Coordinating Entity (RCE)",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://rce.sequoiaproject.org/rce/"
        }
      ]
    }
  ],
  "description" : "The Child profile represents the individual components (such as member organizations, facilities, locations, etc.) that make up a QHIN, Participant, or Subparticipant. A Child can be the parent of other Child organizations. A Child can not be an endpoint (node). It can be part of an endpoint (node) but does not meet the definition of an endpoint (node) itself. The maximum cardinality for an endpoint (node) element under a child is 0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/RCE-Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.extension",
        "path" : "Organization.extension",
        "min" : 2
      },
      {
        "id" : "Organization.extension:org-managing-org",
        "path" : "Organization.extension",
        "sliceName" : "org-managing-org",
        "min" : 1
      },
      {
        "id" : "Organization.type:sequoiaorgtype",
        "path" : "Organization.type",
        "sliceName" : "sequoiaorgtype",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/OrganizationType",
              "code" : "Child"
            }
          ]
        }
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "min" : 1,
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://sequoiaproject.org/fhir/rce/StructureDefinition/QHIN",
              "https://sequoiaproject.org/fhir/rce/StructureDefinition/Participant",
              "https://sequoiaproject.org/fhir/rce/StructureDefinition/SubParticipant",
              "https://sequoiaproject.org/fhir/rce/StructureDefinition/Child"
            ]
          }
        ]
      },
      {
        "id" : "Organization.endpoint",
        "path" : "Organization.endpoint",
        "max" : "0"
      }
    ]
  }
}

```
