# General RCE Participant Example - Recognized Coordinating Entity (RCE) Implementation Guide v1.11.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **General RCE Participant Example**

## Example Organization: General RCE Participant Example



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "1.2.3.4.5",
  "meta" : {
    "profile" : [
      "https://sequoiaproject.org/fhir/rce/StructureDefinition/Participant"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Location",
      "id" : "orgloc",
      "position" : {
        "longitude" : -97.7047386,
        "latitude" : 30.4159542
      }
    },
    {
      "resourceType" : "Endpoint",
      "id" : "RCE-orgEndpoint",
      "extension" : [
        {
          "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/Transaction",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/TransactionCodes",
                "code" : "FHIR REST"
              }
            ]
          }
        },
        {
          "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/Version",
          "valueString" : "4.0.1"
        },
        {
          "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/Roles",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "112247003"
              }
            ]
          }
        },
        {
          "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/Downtime",
          "valuePeriod" : {
            "start" : "2025-01-01T00:00:00+00:00",
            "end" : "2025-01-01T00:00:01+00:00"
          }
        },
        {
          "extension" : [
            {
              "url" : "igCanonicalUrl",
              "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
            },
            {
              "url" : "igPackage",
              "valueUrl" : "https://hl7.org/fhir/us/core/STU6.1/package.tgz"
            },
            {
              "url" : "igVersion",
              "valueString" : "6.1.0"
            },
            {
              "url" : "capStmt",
              "valueUrl" : "http://hl7.org/fhir/us/core/CapabilityStatement/us-core-server"
            }
          ],
          "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/FHIRIGConformance"
        },
        {
          "extension" : [
            {
              "url" : "igCanonicalUrl",
              "valueCanonical" : "http://hl7.org/fhir/us/udap-security/ImplementationGuide/hl7.fhir.us.udap-security"
            },
            {
              "url" : "igPackage",
              "valueUrl" : "https://hl7.org/fhir/us/udap-security/package.tgz"
            },
            {
              "url" : "igVersion",
              "valueString" : "1.1.0"
            }
          ],
          "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/FHIRIGConformance"
        }
      ],
      "identifier" : [
        {
          "use" : "official",
          "type" : {
            "coding" : [
              {
                "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/SequoiaIdentifierCodes",
                "code" : "HCID"
              }
            ]
          },
          "system" : "urn:ietf:rfc:3986",
          "value" : "urn:oid:5.5.5.5"
        }
      ],
      "status" : "active",
      "connectionType" : {
        "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
        "code" : "ihe-xcpd"
      },
      "name" : "Example RCE Endpoint",
      "managingOrganization" : {
        "reference" : "Organization/QHIN-example"
      },
      "payloadType" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
              "code" : "NI"
            }
          ]
        }
      ],
      "payloadMimeType" : ["application/xml"],
      "address" : "https://example.org/xcpd/v1/xcpd"
    }
  ],
  "extension" : [
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/Domains",
      "valueCoding" : {
        "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/Domains",
        "code" : "RCE"
      }
    },
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/UseCases",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/EndpointUseCaseCodes",
            "code" : "QueryBasedDocumentExchange"
          }
        ]
      }
    },
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/PurposesOfUse",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/RCE-Purpose",
            "code" : "T-TREAT"
          }
        ]
      }
    },
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/org-managing-org",
      "valueReference" : {
        "reference" : "Organization/QHIN-example"
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/SequoiaIdentifierCodes",
            "code" : "HCID"
          }
        ]
      },
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:1.2.3.4.5"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/SequoiaIdentifierCodes",
            "code" : "TEFCAID"
          }
        ]
      },
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:5.5.5.5"
    },
    {
      "system" : "urn:oid:2.16.840.1.113883.4.336",
      "value" : "some-CCN-identifier-code"
    }
  ],
  "active" : false,
  "type" : [
    {
      "coding" : [
        {
          "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/OrganizationType",
          "code" : "Participant",
          "display" : "Participant"
        }
      ]
    }
  ],
  "name" : "RCE Participant Example",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-555-5555",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "test21@example.org",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "extension" : [
        {
          "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/OrgLocation",
          "valueReference" : {
            "reference" : "#orgloc"
          }
        }
      ],
      "use" : "work",
      "type" : "both",
      "text" : "Primary",
      "line" : ["200 Main St."],
      "city" : "Austin",
      "state" : "TX",
      "postalCode" : "2472",
      "country" : "US"
    }
  ],
  "partOf" : {
    "reference" : "Organization/QHIN-example",
    "display" : "RCE QHIN Example"
  },
  "contact" : [
    {
      "purpose" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/contactentity-type",
            "code" : "ADMIN",
            "display" : "Administrative"
          }
        ]
      },
      "name" : {
        "use" : "official",
        "text" : "Family, Given"
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "555-555-5555",
          "use" : "work"
        },
        {
          "system" : "email",
          "value" : "test21@example.org",
          "use" : "work"
        }
      ],
      "address" : {
        "use" : "work",
        "type" : "both",
        "text" : "Primary",
        "line" : ["100 Main St."],
        "city" : "Austin",
        "postalCode" : "78737",
        "country" : "US"
      }
    }
  ],
  "endpoint" : [
    {
      "reference" : "#RCE-orgEndpoint"
    }
  ]
}

```
