# Subparticipant - Recognized Coordinating Entity (RCE) Implementation Guide v1.11.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Subparticipant**

## Resource Profile: Subparticipant 

| | |
| :--- | :--- |
| *Official URL*:https://sequoiaproject.org/fhir/rce/StructureDefinition/SubParticipant | *Version*:1.11.0 |
| Active as of 2026-02-12 | *Computable Name*:Subparticipant |

 
The Subparticipant profile represents a Subparticipant as defined in the Common Agreement. A Subparticipant can be the parent of Subparticipant and Child organizations. 

**Usages:**

* Refer to this Profile: [Child](StructureDefinition-Child.md) and [Subparticipant](StructureDefinition-SubParticipant.md)
* Examples for this Profile: [RCE Subparticipant Example](Organization-5.4.3.2.1.md), [Sub Z](Organization-Q.A.P.1.1.md), [Sub Y](Organization-Q.A.P.1.2.md), [Sub U](Organization-Q.B.P.3.1.1.md)... Show 2 more, [Sub W](Organization-Q.B.P.3.1.md) and [Sub V](Organization-Q.B.P.3.2.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/sequoia.fhir.us.rce|current/StructureDefinition/SubParticipant)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SubParticipant.csv), [Excel](StructureDefinition-SubParticipant.xlsx), [Schematron](StructureDefinition-SubParticipant.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SubParticipant",
  "url" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/SubParticipant",
  "version" : "1.11.0",
  "name" : "Subparticipant",
  "title" : "Subparticipant",
  "status" : "active",
  "date" : "2026-02-12T10:03:34-05:00",
  "publisher" : "Recognized Coordinating Entity (RCE)",
  "contact" : [
    {
      "name" : "Recognized Coordinating Entity (RCE)",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://rce.sequoiaproject.org/rce/"
        }
      ]
    }
  ],
  "description" : "The Subparticipant profile represents a Subparticipant as defined in the Common Agreement. A Subparticipant can be the parent of Subparticipant and Child organizations.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/RCE-Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.extension",
        "path" : "Organization.extension",
        "min" : 2
      },
      {
        "id" : "Organization.extension:org-managing-org",
        "path" : "Organization.extension",
        "sliceName" : "org-managing-org",
        "min" : 1
      },
      {
        "id" : "Organization.type:sequoiaorgtype",
        "path" : "Organization.type",
        "sliceName" : "sequoiaorgtype",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/OrganizationType",
              "code" : "Subparticipant"
            }
          ]
        }
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "min" : 1,
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://sequoiaproject.org/fhir/rce/StructureDefinition/QHIN",
              "https://sequoiaproject.org/fhir/rce/StructureDefinition/Participant",
              "https://sequoiaproject.org/fhir/rce/StructureDefinition/SubParticipant"
            ]
          }
        ]
      }
    ]
  }
}

```
