# Artifacts Summary - Recognized Coordinating Entity (RCE) Implementation Guide v1.11.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Operation Definitions 

These are custom operations that can be supported by and/or invoked by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Activate Hierarchy](OperationDefinition-activate-hierarchy.md) | This operation changes the Organization.active element to true for the specified Organization and all Organizations that descend from it (directly or indirectly) via Organization.partOf. |
| [Deactivate Hierarchy](OperationDefinition-deactivate-hierarchy.md) | This operation changes the Organization.active element to false for the specified Organization and all Organizations that descend from it (directly or indirectly) via Organization.partOf. |
| [Update TEFCAID for Entry and Children](OperationDefinition-update-tefcaid.md) | This operation updates the TEFCAID identifier for the specified Organization and all Child Organizations that descend from it (directly or indirectly through other Children) via Organization.partOf. |

### Structures: Abstract Profiles 

These are profiles on resources or data types that describe patterns used by other profiles, but cannot be instantiated directly. I.e. instances can conform to profiles **based** on these abstract profiles but do not declare conformance to the abstract profiles themselves.

| | |
| :--- | :--- |
| [RCE Organization](StructureDefinition-RCE-Organization.md) | This profile on the FHIR Organization resource is an abstract base profile that defines shared constraints for all other profiles on the Organization resource in this implementation guide. It is not intended to be used directly, rather end users should create instances conforming to the QHIN, Participant, Subparticipant, or Child profiles. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Child](StructureDefinition-Child.md) | The Child profile represents the individual components (such as member organizations, facilities, locations, etc.) that make up a QHIN, Participant, or Subparticipant. A Child can be the parent of other Child organizations. A Child can not be an endpoint (node). It can be part of an endpoint (node) but does not meet the definition of an endpoint (node) itself. The maximum cardinality for an endpoint (node) element under a child is 0. |
| [Participant](StructureDefinition-Participant.md) | The Participant profile represents a Participant as defined in the Common Agreement. A Participant can be the parent of Subparticipant and Child organizations. |
| [QHIN](StructureDefinition-QHIN.md) | The QHIN profile represents a Qualified Health Information Network as defined in the Common Agreement. A QHIN can be the parent of Participant, Subparticipant, and Child organizations. There will be exactly one QHIN Organization resource per Designated QHIN. |
| [RCE Endpoint](StructureDefinition-RCE-Endpoint.md) | This profile on the FHIR Endpoint resource represents information about the endpoints provided by Organizations participating in TEFCA exchange. The endpoints described can use any QTF-supported protocol, such as IHE XCA, and need not be FHIR endpoints. |
| [Subparticipant](StructureDefinition-SubParticipant.md) | The Subparticipant profile represents a Subparticipant as defined in the Common Agreement. A Subparticipant can be the parent of Subparticipant and Child organizations. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [General RCE Child Example](Organization-RCE-Child-example.md) | Example RCE Child Organization instance. This example shows a 3rd-level organization below the RCE Subparticipant example. |
| [General RCE Endpoint Example](Endpoint-RCE-orgEndpoint.md) | Example RCE Endpoint instance. Note that the RCE Directory currently expects Endpoint instances to be contained resources within an Organization resource. |
| [General RCE Participant Example](Organization-1.2.3.4.5.md) | Example RCE Participant Organization instance. This example shows a top level organization participating in a QHIN, which is the direct parent of the RCE Subparticipant example. In includes a contained FHIR Endpoint. |
| [General RCE QHIN Example](Organization-QHIN-example.md) | Example RCE QHIN Organization instance. This example shows a TEFCA Qualified Health Information Network (QHIN) organization in the RCE directory. It is the top-level parent of the other examples in this IG, and the direct parent of the RCE Participant example. |
| [General RCE Subparticipant Example](Organization-5.4.3.2.1.md) | Example RCE Participant Organization instance. This example shows a 2nd level organization below an RCE Participant organization. This example is the direct parent of the RCE Child example. It includes a contained XCDR Endpoint. |
| [Participant 1](Organization-Q.A.P.1.md) | This example shows Participant 1, a top level organization participating in a QHIN A. Participant 1 maintains an eMPI/Record Locator Service (RLS) over its Subparticipants, Sub Y and Sub Z, but returns individual patient IDs per Subparticipant and passes down subsequent Queries for documents. |
| [Participant 2](Organization-Q.A.P.2.md) | This example shows Participant 2, a top level organization participating in a QHIN A. Participant 2 maintains a complete clinical data repository and Responds for all transactions for its Subparticipant, Sub X. |
| [Participant 3](Organization-Q.B.P.3.md) | This example shows Participant 3, a top level organization participating in a QHIN B. Participant 3 is a fully federated Passthrough Node, passing all transactions to its Subparticipants, Sub U, Sub V, and Sub W. |
| [QHIN A](Organization-Q.A.0.0.md) | This example shows QHIN A, which is fully federated (no centralized data or patient index) and passes all transactions to its participants, Participant 1 and Participant 2. |
| [QHIN B](Organization-Q.B.0.0.md) | This example shows QHIN B, which maintains an eMPI/RLS and returns a consolidated patient ID, followed by an aggregated document list. It passes down subsequent Queries for documents to its participant, Participant 3. |
| [Sub U](Organization-Q.B.P.3.1.1.md) | This example shows Sub U, a Subparticipant (3rd level organization) of Sub W. It only sees Document Retrieval Queries and Responds independently (XCA Responds), since Sub W and Participant 3 are fully federated Passthrough Nodes and QHIN B maintains its patient demographics and document list. |
| [Sub V](Organization-Q.B.P.3.2.md) | This example shows Sub V, a Subparticipant (2nd level organization) of Participant 3. It only sees Document Retrieval Queries and Responds independently (XCA Responds), since Participant 3 is a fully federated Passthrough Node and QHIN B maintains its patient demographics and document list. |
| [Sub W](Organization-Q.B.P.3.1.md) | This example shows Sub W, a Subparticipant (2nd level organization) of Participant 3. It is a fully federated Passthrough Node, passing all transactions to its Subparticipant, Sub U. |
| [Sub X](Organization-Q.A.P.2.1.md) | This example shows a Child (a 2nd-level organization with no Endpoint) of Participant 2, called 'Sub X'. It never sees or Responds directly to TEFCA transactions, since Participant 2 maintains a complete clinical data repository and Responds for all transactions for all of its Child sorganization. |
| [Sub Y](Organization-Q.A.P.1.2.md) | This example shows Sub Y, a Subparticipant (2nd level organization) of Participant 1. It sees only Document Query and Document Retrieval Queries from Participant 1, and it Respond independently (XCA Queries and Responds), since Participant 1 only maintains its patient demographics. |
| [Sub Z](Organization-Q.A.P.1.1.md) | This example shows Sub Z, a Subparticipant (2nd level organization) of Participant 1. It sees only Document Query and Document Retrieval Queries from Participant 1, and it Respond independently (XCA Queries and Responds), since Participant 1 only maintains its patient demographics. |

