# Sub V - Recognized Coordinating Entity (RCE) Implementation Guide v1.9.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Sub V**

## Example Organization: Sub V



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "Q.B.P.3.2",
  "meta" : {
    "profile" : [
      "https://sequoiaproject.org/fhir/rce/StructureDefinition/SubParticipant"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Location",
      "id" : "orgloc",
      "position" : {
        "longitude" : -97.7047386,
        "latitude" : 30.4159542
      }
    },
    {
      "resourceType" : "Endpoint",
      "id" : "Endpoint-Sub-V-1",
      "meta" : {
        "profile" : [
          "https://sequoiaproject.org/fhir/rce/StructureDefinition/RCE-Endpoint"
        ]
      },
      "extension" : [
        {
          "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/Transaction",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/TransactionCodes",
                "code" : "XCA ITI-38"
              }
            ]
          }
        },
        {
          "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/EndpointType",
          "valueCoding" : {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/EndpointType",
            "code" : "responding-node"
          }
        }
      ],
      "identifier" : [
        {
          "use" : "official",
          "type" : {
            "coding" : [
              {
                "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/SequoiaIdentifierCodes",
                "code" : "HCID"
              }
            ]
          },
          "system" : "urn:ietf:rfc:3986",
          "value" : "urn:oid:5.5.5.5"
        }
      ],
      "status" : "active",
      "connectionType" : {
        "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
        "code" : "ihe-xca"
      },
      "name" : "Endpoint-Sub-V-1",
      "managingOrganization" : {
        "reference" : "Organization/Q.B.P.3.2"
      },
      "payloadType" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
              "code" : "NI"
            }
          ]
        }
      ],
      "payloadMimeType" : ["application/xml"],
      "_address" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "resourceType" : "Endpoint",
      "id" : "Endpoint-Sub-V-2",
      "meta" : {
        "profile" : [
          "https://sequoiaproject.org/fhir/rce/StructureDefinition/RCE-Endpoint"
        ]
      },
      "extension" : [
        {
          "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/Transaction",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/TransactionCodes",
                "code" : "XCA ITI-39"
              }
            ]
          }
        },
        {
          "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/EndpointType",
          "valueCoding" : {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/EndpointType",
            "code" : "responding-node"
          }
        }
      ],
      "identifier" : [
        {
          "use" : "official",
          "type" : {
            "coding" : [
              {
                "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/SequoiaIdentifierCodes",
                "code" : "HCID"
              }
            ]
          },
          "system" : "urn:ietf:rfc:3986",
          "value" : "urn:oid:5.5.5.5"
        }
      ],
      "status" : "active",
      "connectionType" : {
        "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
        "code" : "ihe-xca"
      },
      "name" : "Endpoint-Sub-V-2",
      "managingOrganization" : {
        "reference" : "Organization/Q.B.P.3.2"
      },
      "payloadType" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
              "code" : "NI"
            }
          ]
        }
      ],
      "payloadMimeType" : ["application/xml"],
      "_address" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    }
  ],
  "extension" : [
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/Domains",
      "valueCoding" : {
        "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/Domains",
        "code" : "RCE"
      }
    },
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/UseCases",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/EndpointUseCaseCodes",
            "code" : "QueryBasedDocumentExchange"
          }
        ]
      }
    },
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/org-managing-org",
      "valueReference" : {
        "reference" : "Organization/Q.B.P.3"
      }
    },
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/Transaction",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/TransactionCodes",
            "code" : "XCA ITI-38"
          }
        ]
      }
    },
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/Transaction",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/TransactionCodes",
            "code" : "XCA ITI-39"
          }
        ]
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/SequoiaIdentifierCodes",
            "code" : "HCID"
          }
        ]
      },
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:Q.B.P.3.2"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/SequoiaIdentifierCodes",
            "code" : "TEFCAID"
          }
        ]
      },
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:5.5.5.5"
    },
    {
      "system" : "urn:oid:2.16.840.1.113883.4.336",
      "value" : "some-CCN-identifier-code"
    }
  ],
  "active" : false,
  "type" : [
    {
      "coding" : [
        {
          "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/OrganizationType",
          "code" : "Subparticipant",
          "display" : "Subparticipant"
        }
      ]
    }
  ],
  "name" : "Sub V",
  "address" : [
    {
      "extension" : [
        {
          "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/OrgLocation",
          "valueReference" : {
            "reference" : "#orgloc"
          }
        }
      ],
      "use" : "work",
      "type" : "both",
      "text" : "200 Main St., Austin TX 2472",
      "line" : ["200 Main St."],
      "city" : "Austin",
      "state" : "TX",
      "postalCode" : "2472",
      "country" : "US"
    }
  ],
  "partOf" : {
    "reference" : "Organization/Q.B.P.3",
    "display" : "Participant 3"
  },
  "contact" : [
    {
      "purpose" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/contactentity-type",
            "code" : "ADMIN",
            "display" : "Administrative"
          }
        ]
      },
      "name" : {
        "use" : "official",
        "text" : "Family, Given"
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "555-555-5555",
          "use" : "work"
        },
        {
          "system" : "email",
          "value" : "test21@test.com",
          "use" : "work"
        }
      ],
      "address" : {
        "use" : "work",
        "type" : "both",
        "text" : "100 Main St, Austin TX 78737",
        "line" : ["100 Main St."],
        "city" : "Austin",
        "postalCode" : "78737",
        "country" : "US"
      }
    }
  ],
  "endpoint" : [
    {
      "reference" : "#Endpoint-Sub-V-1"
    },
    {
      "reference" : "#Endpoint-Sub-V-2"
    }
  ]
}

```
