# General RCE QHIN Example - Recognized Coordinating Entity (RCE) Implementation Guide v1.9.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **General RCE QHIN Example**

## Example Organization: General RCE QHIN Example



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "QHIN-example",
  "meta" : {
    "profile" : [
      "https://sequoiaproject.org/fhir/rce/StructureDefinition/QHIN"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Location",
      "id" : "orgloc",
      "position" : {
        "longitude" : -97.7047386,
        "latitude" : 30.4159542
      }
    }
  ],
  "extension" : [
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/Domains",
      "valueCoding" : {
        "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/Domains",
        "code" : "RCE"
      }
    },
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/UseCases",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/EndpointUseCaseCodes",
            "code" : "QueryBasedDocumentExchange"
          }
        ]
      }
    },
    {
      "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/org-managing-org",
      "valueReference" : {
        "reference" : "Organization/QHIN-example"
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/SequoiaIdentifierCodes",
            "code" : "HCID"
          }
        ]
      },
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:5.5.5.5"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/SequoiaIdentifierCodes",
            "code" : "TEFCAID"
          }
        ]
      },
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:5.5.5.5"
    },
    {
      "system" : "urn:oid:2.16.840.1.113883.4.336",
      "value" : "some-CCN-identifier-code"
    }
  ],
  "active" : false,
  "type" : [
    {
      "coding" : [
        {
          "system" : "https://sequoiaproject.org/fhir/sphd/CodeSystem/OrganizationType",
          "code" : "QHIN",
          "display" : "QHIN"
        }
      ]
    }
  ],
  "name" : "RCE QHIN Example",
  "address" : [
    {
      "extension" : [
        {
          "url" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/OrgLocation",
          "valueReference" : {
            "reference" : "#orgloc"
          }
        }
      ],
      "use" : "work",
      "type" : "both",
      "text" : "Primary",
      "line" : ["200 Main St."],
      "city" : "Austin",
      "state" : "TX",
      "postalCode" : "2472",
      "country" : "US"
    }
  ],
  "contact" : [
    {
      "purpose" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/contactentity-type",
            "code" : "ADMIN",
            "display" : "Administrative"
          }
        ]
      },
      "name" : {
        "use" : "official",
        "text" : "Family, Given"
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "555-555-5555",
          "use" : "work"
        },
        {
          "system" : "email",
          "value" : "test21@test.com",
          "use" : "work"
        }
      ],
      "address" : {
        "use" : "work",
        "type" : "both",
        "text" : "Primary",
        "line" : ["100 Main St."],
        "city" : "Austin",
        "postalCode" : "78737",
        "country" : "US"
      }
    }
  ]
}

```
