# RCE Organization - Recognized Coordinating Entity (RCE) Implementation Guide v1.9.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RCE Organization**

## Resource Profile: RCE Organization ( Abstract ) 

| | |
| :--- | :--- |
| *Official URL*:https://sequoiaproject.org/fhir/rce/StructureDefinition/RCE-Organization | *Version*:1.9.0 |
| Active as of 2025-12-22 | *Computable Name*:RCEOrganization |

 
This profile on the FHIR Organization resource is an abstract base profile that defines shared constraints for all other profiles on the Organization resource in this implementation guide. It is not intended to be used directly, rather end users should create instances conforming to the QHIN, Participant, Subparticipant, or Child profiles. 

**Usages:**

* Derived from this Profile: [Child](StructureDefinition-Child.md), [Participant](StructureDefinition-Participant.md), [QHIN](StructureDefinition-QHIN.md) and [Subparticipant](StructureDefinition-SubParticipant.md)
* Refer to this Profile: [RCE Endpoint](StructureDefinition-RCE-Endpoint.md) and [RCE Organization](StructureDefinition-RCE-Organization.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/sequoia.fhir.us.rce|current/StructureDefinition/RCE-Organization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-RCE-Organization.csv), [Excel](StructureDefinition-RCE-Organization.xlsx), [Schematron](StructureDefinition-RCE-Organization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "RCE-Organization",
  "url" : "https://sequoiaproject.org/fhir/rce/StructureDefinition/RCE-Organization",
  "version" : "1.9.0",
  "name" : "RCEOrganization",
  "title" : "RCE Organization",
  "status" : "active",
  "date" : "2025-12-22T10:07:35-05:00",
  "publisher" : "Recognized Coordinating Entity (RCE)",
  "contact" : [
    {
      "name" : "Recognized Coordinating Entity (RCE)",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://rce.sequoiaproject.org/rce/"
        }
      ]
    }
  ],
  "description" : "This profile on the FHIR Organization resource is an abstract base profile that defines shared constraints for all other profiles on the Organization resource in this implementation guide. It is not intended to be used directly, rather end users should create instances conforming to the QHIN, Participant, Subparticipant, or Child profiles.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : true,
  "type" : "Organization",
  "baseDefinition" : "https://sequoiaproject.org/fhir/sphd/StructureDefinition/SequoiaOrganization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.extension:purposesofuse",
        "path" : "Organization.extension",
        "sliceName" : "purposesofuse"
      },
      {
        "id" : "Organization.extension:purposesofuse.value[x]",
        "path" : "Organization.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://sequoiaproject.org/fhir/sphd/ValueSet/RCEPurposeVS"
        }
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "min" : 2
      },
      {
        "id" : "Organization.identifier:TEFCAID",
        "path" : "Organization.identifier",
        "sliceName" : "TEFCAID",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organization.telecom:phone",
        "path" : "Organization.telecom",
        "sliceName" : "phone",
        "max" : "1"
      },
      {
        "id" : "Organization.telecom:email",
        "path" : "Organization.telecom",
        "sliceName" : "email",
        "max" : "1"
      },
      {
        "id" : "Organization.address",
        "path" : "Organization.address",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "country"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Organization.address.extension",
        "path" : "Organization.address.extension",
        "min" : 1
      },
      {
        "id" : "Organization.address.text",
        "path" : "Organization.address.text",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Organization.address.country",
        "path" : "Organization.address.country",
        "min" : 1
      },
      {
        "id" : "Organization.address:united-states-address",
        "path" : "Organization.address",
        "sliceName" : "united-states-address",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Organization.address:united-states-address.city",
        "path" : "Organization.address.city",
        "min" : 1
      },
      {
        "id" : "Organization.address:united-states-address.state",
        "path" : "Organization.address.state",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "description" : "Two letter USPS alphabetic codes.",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-usps-state"
        }
      },
      {
        "id" : "Organization.address:united-states-address.postalCode",
        "path" : "Organization.address.postalCode",
        "min" : 1
      },
      {
        "id" : "Organization.address:united-states-address.country",
        "path" : "Organization.address.country",
        "fixedString" : "US"
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://sequoiaproject.org/fhir/rce/StructureDefinition/RCE-Organization"
            ]
          }
        ]
      },
      {
        "id" : "Organization.contact.purpose",
        "path" : "Organization.contact.purpose",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Organization.contact.name",
        "path" : "Organization.contact.name",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Organization.contact.telecom",
        "path" : "Organization.contact.telecom",
        "min" : 2
      },
      {
        "id" : "Organization.contact.telecom:phone",
        "path" : "Organization.contact.telecom",
        "sliceName" : "phone",
        "min" : 1
      },
      {
        "id" : "Organization.contact.telecom:email",
        "path" : "Organization.contact.telecom",
        "sliceName" : "email",
        "min" : 1
      },
      {
        "id" : "Organization.endpoint",
        "path" : "Organization.endpoint",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://sequoiaproject.org/fhir/rce/StructureDefinition/RCE-Endpoint"
            ]
          }
        ]
      }
    ]
  }
}

```
